<?php

class BudynekController extends Controller
{
	public $layout = 'administration';
	public $defaultAction = 'admin';

	public function init()
	{
		Yii::import('application.modules.administration.controllers.MainController');
		$mainController = new MainController('main');
		$this->menu = $mainController->menu;
	}

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl',
			'postOnly + delete',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow authenticated users to perform actions
				'actions'=>array('create','update','delete','admin','view'),
				'roles'=>array('admin')
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view', array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new Budynek;
		$buildingTypes = RodzajBudynku::model()->findAll();
		$maps = Mapa::model()->findAll();

		if(isset($_POST['Budynek']))
		{
			$model->attributes = $_POST['Budynek'];

			if($model->save())
				$this->redirect(array('view', 'id'=>$model->id));
		}

		$this->render('create', array(
			'model'=>$model,
			'buildingTypes'=>$buildingTypes,
			'maps'=>$maps
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);
		$buildingTypes = RodzajBudynku::model()->findAll();
		$maps = Mapa::model()->findAll();

		if(isset($_POST['Budynek']))
		{
			unset($_POST['Budynek']['nazwa']);
			$model->attributes = $_POST['Budynek'];

			if($model->save())
				$this->redirect(array('view', 'id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
			'buildingTypes'=>$buildingTypes,
			'maps'=>$maps
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		try
		{
			$this->loadModel($id)->delete();
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		catch(Exception $e)
		{
			throw new CHttpException(404, 'Nie można usunąć rekordu. Obiekt może być nierozerwalnie połączony z innymi elementami w bazie.');
		}
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new Budynek('search');
		$model->unsetAttributes();

		if(isset($_GET['Budynek']))
			$model->attributes = $_GET['Budynek'];

		$this->render('admin', array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Budynek::model()->findByPk($id);

		if($model === null)
			throw new CHttpException(404, Yii::t('The requested page does not exist.'));

		return $model;
	}
}